#pragma once

#include "Log.h"
#include "FTNStruc.hpp"
#include "Flag.h"
#include "LineFormat.h"

#include "Singletons.h"

enum { ROUTE_NONE = 0, ROUTE_SEND = 1, ROUTE_RECEIVE = 2, ROUTE_BIDIRECT = 3 };

enum { ACTIVITY_USUAL, ACTIVITY_PASSIVE, ACTIVITY_UNAVAILABLE };

enum { MSGDATA_NONE, MSGDATA_COMMAND, MSGDATA_SUBSCRIBE, MSGDATA_UNSUBSCRIBE };

enum OutboundType {
	OT_BINKLEY,
	OT_FILE_BOXES
};

enum FlavourType {
    FT_NORMAL    = 0,
    FT_CRASH     = 1,
    FT_DIRECT    = 2,
    FT_HOLD      = 4,
    FT_IMMEDIATE = 8
};

const	uint16	WARN_SYSOP_ABOUT_WARNINGS = 1,
		WARN_SYSOP_ABOUT_ERRORS   = 2;

#if defined(UNICODE)
typedef	wofstream	tofstream;
#define	COUT	wcout
#define	CERR	wcerr
#else
typedef ofstream	tofstream;
#define	COUT	cout
#define	CERR	cerr
#endif

const LPCTSTR	TEXT_EOL = TEXT("\n");	// end of line string

const TCHAR		PATH_SEPARATOR     = TEXT('\\');
const LPCTSTR	PATH_SEPARATOR_STR = TEXT("\\");

const TCHAR	SPACE_CHAR = TEXT(' ');
const TCHAR	TAB_CHAR   = TEXT('\011');
const TCHAR	ZERO_CHAR  = TEXT('\000');

typedef	vector<SFTNAddress>	VAddr;

struct SMsgData {
	int		m_iType;
	tstring	m_sLine;
	tstring	m_sTail;
};

// common constants

const int	LONG_DESC_PREFIX_SIZE = 128;
const int	TEARLINE_SIZE         = 80;

extern	LPCTSTR	c_szForwardsFileName;

struct SGlobalVars {
	SFTNAddress		m_addrMain;
	VAddr			m_vAKAAddr;
	TCHAR			m_szSysOp[36];
	TCHAR			m_szInboundPath[MAX_PATH];
	TCHAR			m_szOutboundPath[MAX_PATH];
	TCHAR			m_szBinkOutboundPath[MAX_PATH];
	TCHAR			m_szNetmailPath[MAX_PATH];
	TCHAR			m_szBadTicsPath[MAX_PATH];
	TCHAR			m_szNewTicsPath[MAX_PATH];
	TCHAR			m_szProcessedTicsPath[MAX_PATH];
	TCHAR			m_szAutoCreatedPath[MAX_PATH];
	TCHAR			m_szAutoDescFileName[MAX_PATH];
	TCHAR			m_szLongDescPrefix[LONG_DESC_PREFIX_SIZE+1];
	TCHAR			m_szFilelistFileName[MAX_PATH];
	CLineFormat		m_fileListFormat;
	CFlag			m_fLongPaths;
	vector<tstring>		m_vsAliases;
	vector<SMsgData>	m_vMsgData;
	CFlag			m_fHandleReplaces;
	CFlag			m_fHatchOriginMain;
	CFlag			m_fAllAKASeen;
	CFlag			m_fKillProcessedMail;
	CFlag			m_fShowMustGoOn;
	CFlag			m_fLogMsgNames;
	TCHAR			m_szFixFlagName[MAX_PATH];
	TCHAR			m_szTossFlagName[MAX_PATH];
	TCHAR			m_szHatchFlagName[MAX_PATH];
	CFlag			m_fCheckDomainInBSO;
	int			m_nForwardExpirationTime;	// days
	void			FreeMsgData();
	CLog			m_log;
	CFlag			m_flagConcatDescriptions;	// concat Desc & LDesc lines
								// while creating TIC
	int			m_nMessageKBytesLimit;	// in _bytes_
	int			m_nMessageLinesLimit;

	TCHAR			m_szTearLine[TEARLINE_SIZE];

	uint16			m_nWarnSysopByMail;	// bitfield
										// bits to check:
										// WARN_SYSOP_ABOUT_WARNINGS
										// WARN_SYSOP_ABOUT_ERRORS

	uint16			m_nNoMailNotify;	// bitfield
										// bits to check
										// 1 - no notify about base purge

	uint16			m_nReplyMessageAttrs;
	uint16			m_nReplyMessageFlags;
	int				maxTicAge;
};

extern SGlobalVars g_vars;


struct SWarnings {
	CFlag	m_flagIncorrectCRC32;
};

extern SWarnings g_warnings;


class CCommonData : public CSingleton {
public:
	
	// file boxes

	void setFileBoxesPath(const tstring& newPath) { fileBoxesPath = newPath; }
	const tstring& getFileBoxesPath() const { return fileBoxesPath; }
	void setLongFileBoxes(bool newFlag) { longFileBoxes = newFlag; }
	bool areLongFileBoxes() const { return longFileBoxes; }

	// singleton implementation

	virtual void destroy() {}
	virtual CSingletonVector getDependencies() { return CSingletonVector(); }

	static CCommonData* getInstance() {
		static CCommonData	commonData;

		return &commonData;
	}

protected:
	CCommonData() : CSingleton() {}

	tstring	fileBoxesPath;
	bool	longFileBoxes;
};
typedef CCommonData*	CommonDataPtr;
